/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.axis.rm;

import filenet.vw.base.logging.Logger;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.i18n.Messages;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.providers.java.MsgProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSRMMsgProvider
extends MsgProvider {
    protected static Logger logger = Logger.getLogger("filenet.ws.listener.axis.rm");
    private static Hashtable MessageContexts = new Hashtable();
    private static final String m_className = "WSRMMSGProvider";

    public static String _get_FILE_DATE() {
        return "$Date:   02 Oct 2008 10:24:00  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.1  $";
    }

    public void processMessage(MessageContext msgContext, SOAPEnvelope reqEnv, SOAPEnvelope resEnv, Object obj) throws Exception {
        String m_method = "processMessage";
        logger.entering(m_className, m_method);
        try {
            MessageElement element;
            Vector bodyElements;
            OperationDesc operation = msgContext.getOperation();
            SOAPService service = msgContext.getService();
            ServiceDesc serviceDesc = service.getServiceDescription();
            QName opQName = null;
            if (operation == null && (bodyElements = reqEnv.getBodyElements()).size() > 0 && (element = (MessageElement)bodyElements.get(0)) != null) {
                opQName = new QName(element.getNamespaceURI(), element.getLocalName());
                operation = serviceDesc.getOperationByElementQName(opQName);
            }
            if (operation == null) {
                throw new AxisFault(Messages.getMessage((String)"noOperationForQName", (String)(opQName == null ? "null" : opQName.toString())));
            }
            Method method = operation.getMethod();
            int methodType = operation.getMessageOperationStyle();
            if (methodType != 2) {
                Vector bodies = reqEnv.getBodyElements();
                Object[] argObjects = new Object[1];
                switch (methodType) {
                    case 1: {
                        SOAPBodyElement[] bodyElements2 = new SOAPBodyElement[bodies.size()];
                        bodies.toArray(bodyElements2);
                        argObjects[0] = bodyElements2;
                        MessageContexts.put(bodyElements2, msgContext);
                        SOAPBodyElement[] bodyResult = (SOAPBodyElement[])method.invoke(obj, argObjects);
                        if (bodyResult != null) {
                            for (int i = 0; i < bodyResult.length; ++i) {
                                SOAPBodyElement bodyElement = bodyResult[i];
                                resEnv.addBodyElement(bodyElement);
                            }
                        }
                        return;
                    }
                    case 3: {
                        Element[] elements = new Element[bodies.size()];
                        for (int i = 0; i < elements.length; ++i) {
                            SOAPBodyElement body = (SOAPBodyElement)bodies.get(i);
                            elements[i] = body.getAsDOM();
                        }
                        MessageContexts.put(elements, msgContext);
                        argObjects[0] = elements;
                        Element[] elemResult = (Element[])method.invoke(obj, argObjects);
                        if (elemResult != null) {
                            for (int i = 0; i < elemResult.length; ++i) {
                                if (elemResult[i] == null) continue;
                                resEnv.addBodyElement(new SOAPBodyElement(elemResult[i]));
                            }
                        }
                        return;
                    }
                    case 4: {
                        Document doc = ((SOAPBodyElement)bodies.get(0)).getAsDocument();
                        MessageContexts.put(doc, msgContext);
                        argObjects[0] = doc;
                        Document resultDoc = (Document)method.invoke(obj, argObjects);
                        if (resultDoc != null) {
                            resEnv.addBodyElement(new SOAPBodyElement(resultDoc.getDocumentElement()));
                        }
                        return;
                    }
                }
            } else {
                Object[] argObjects = new Object[]{reqEnv, resEnv};
                method.invoke(obj, argObjects);
                return;
            }
            throw new AxisFault(Messages.getMessage((String)"badMsgMethodStyle"));
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    public static MessageContext getMessageContext(Element[] body) {
        Object obj = MessageContexts.get(body);
        if (obj != null && obj instanceof MessageContext) {
            MessageContexts.remove(body);
            return (MessageContext)obj;
        }
        return null;
    }
}

